/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get all the usage plan keys representing the API keys added to a specified usage plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanKeysRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsagePlanKeysRequest.Builder, GetUsagePlanKeysRequest> {
    private final String usagePlanId;

    private final String position;

    private final Integer limit;

    private final String nameQuery;

    private GetUsagePlanKeysRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.position = builder.position;
        this.limit = builder.limit;
        this.nameQuery = builder.nameQuery;
    }

    /**
     * <p>
     * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
     * <a>UsagePlanKey</a> resource representing a plan customer.
     * </p>
     * 
     * @return [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
     *         to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * The current pagination position in the paged result set.
     * </p>
     * 
     * @return The current pagination position in the paged result set.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     * </p>
     * 
     * @return The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A query parameter specifying the name of the to-be-returned usage plan keys.
     * </p>
     * 
     * @return A query parameter specifying the name of the to-be-returned usage plan keys.
     */
    public String nameQuery() {
        return nameQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nameQuery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanKeysRequest)) {
            return false;
        }
        GetUsagePlanKeysRequest other = (GetUsagePlanKeysRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(position(), other.position())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nameQuery(), other.nameQuery());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUsagePlanKeysRequest").add("UsagePlanId", usagePlanId()).add("Position", position())
                .add("Limit", limit()).add("NameQuery", nameQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "nameQuery":
            return Optional.ofNullable(clazz.cast(nameQuery()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetUsagePlanKeysRequest> {
        /**
         * <p>
         * [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the to-be-retrieved
         * <a>UsagePlanKey</a> resource representing a plan customer.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The Id of the <a>UsagePlan</a> resource representing the usage plan containing the
         *        to-be-retrieved <a>UsagePlanKey</a> resource representing a plan customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * The current pagination position in the paged result set.
         * </p>
         * 
         * @param position
         *        The current pagination position in the paged result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * </p>
         * 
         * @param limit
         *        The maximum number of returned results per page. The default value is 25 and the maximum value is 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A query parameter specifying the name of the to-be-returned usage plan keys.
         * </p>
         * 
         * @param nameQuery
         *        A query parameter specifying the name of the to-be-returned usage plan keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameQuery(String nameQuery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private String position;

        private Integer limit;

        private String nameQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanKeysRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
            position(model.position);
            limit(model.limit);
            nameQuery(model.nameQuery);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNameQuery() {
            return nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsagePlanKeysRequest build() {
            return new GetUsagePlanKeysRequest(this);
        }
    }
}
