/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GET request to get a usage plan of a given plan identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUsagePlanRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<GetUsagePlanRequest.Builder, GetUsagePlanRequest> {
    private final String usagePlanId;

    private GetUsagePlanRequest(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
    }

    /**
     * <p>
     * [Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.
     * </p>
     * 
     * @return [Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUsagePlanRequest)) {
            return false;
        }
        GetUsagePlanRequest other = (GetUsagePlanRequest) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetUsagePlanRequest").add("UsagePlanId", usagePlanId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, GetUsagePlanRequest> {
        /**
         * <p>
         * [Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.
         * </p>
         * 
         * @param usagePlanId
         *        [Required] The identifier of the <a>UsagePlan</a> resource to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String usagePlanId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUsagePlanRequest model) {
            super(model);
            usagePlanId(model.usagePlanId);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetUsagePlanRequest build() {
            return new GetUsagePlanRequest(this);
        }
    }
}
