/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.MethodSnapshotMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a summary of a <a>Method</a> resource, given a particular date and time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MethodSnapshot implements StructuredPojo, ToCopyableBuilder<MethodSnapshot.Builder, MethodSnapshot> {
    private final String authorizationType;

    private final Boolean apiKeyRequired;

    private MethodSnapshot(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.apiKeyRequired = builder.apiKeyRequired;
    }

    /**
     * <p>
     * The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for
     * using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or <code>COGNITO_USER_POOLS</code>
     * for using a Cognito user pool.
     * </p>
     * 
     * @return The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code>
     *         for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
     *         <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
     */
    public String authorizationType() {
        return authorizationType;
    }

    /**
     * <p>
     * Specifies whether the method requires a valid <a>ApiKey</a>.
     * </p>
     * 
     * @return Specifies whether the method requires a valid <a>ApiKey</a>.
     */
    public Boolean apiKeyRequired() {
        return apiKeyRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyRequired());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodSnapshot)) {
            return false;
        }
        MethodSnapshot other = (MethodSnapshot) obj;
        return Objects.equals(authorizationType(), other.authorizationType())
                && Objects.equals(apiKeyRequired(), other.apiKeyRequired());
    }

    @Override
    public String toString() {
        return ToString.builder("MethodSnapshot").add("AuthorizationType", authorizationType())
                .add("ApiKeyRequired", apiKeyRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationType":
            return Optional.ofNullable(clazz.cast(authorizationType()));
        case "apiKeyRequired":
            return Optional.ofNullable(clazz.cast(apiKeyRequired()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MethodSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MethodSnapshot> {
        /**
         * <p>
         * The method's authorization type. Valid values are <code>NONE</code> for open access, <code>AWS_IAM</code> for
         * using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer, or
         * <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * </p>
         * 
         * @param authorizationType
         *        The method's authorization type. Valid values are <code>NONE</code> for open access,
         *        <code>AWS_IAM</code> for using AWS IAM permissions, <code>CUSTOM</code> for using a custom authorizer,
         *        or <code>COGNITO_USER_POOLS</code> for using a Cognito user pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * Specifies whether the method requires a valid <a>ApiKey</a>.
         * </p>
         * 
         * @param apiKeyRequired
         *        Specifies whether the method requires a valid <a>ApiKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyRequired(Boolean apiKeyRequired);
    }

    static final class BuilderImpl implements Builder {
        private String authorizationType;

        private Boolean apiKeyRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(MethodSnapshot model) {
            authorizationType(model.authorizationType);
            apiKeyRequired(model.apiKeyRequired);
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final Boolean getApiKeyRequired() {
            return apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        @Override
        public MethodSnapshot build() {
            return new MethodSnapshot(this);
        }
    }
}
