/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.QuotaSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Quotas configured for a usage plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuotaSettings implements StructuredPojo, ToCopyableBuilder<QuotaSettings.Builder, QuotaSettings> {
    private final Integer limit;

    private final Integer offset;

    private final String period;

    private QuotaSettings(BuilderImpl builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.period = builder.period;
    }

    /**
     * <p>
     * The maximum number of requests that can be made in a given time period.
     * </p>
     * 
     * @return The maximum number of requests that can be made in a given time period.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The number of requests subtracted from the given limit in the initial time period.
     * </p>
     * 
     * @return The number of requests subtracted from the given limit in the initial time period.
     */
    public Integer offset() {
        return offset;
    }

    /**
     * <p>
     * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link QuotaPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     * @see QuotaPeriodType
     */
    public QuotaPeriodType period() {
        return QuotaPeriodType.fromValue(period);
    }

    /**
     * <p>
     * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link QuotaPeriodType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
     * @see QuotaPeriodType
     */
    public String periodAsString() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaSettings)) {
            return false;
        }
        QuotaSettings other = (QuotaSettings) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(offset(), other.offset())
                && Objects.equals(periodAsString(), other.periodAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("QuotaSettings").add("Limit", limit()).add("Offset", offset()).add("Period", periodAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QuotaSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, QuotaSettings> {
        /**
         * <p>
         * The maximum number of requests that can be made in a given time period.
         * </p>
         * 
         * @param limit
         *        The maximum number of requests that can be made in a given time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The number of requests subtracted from the given limit in the initial time period.
         * </p>
         * 
         * @param offset
         *        The number of requests subtracted from the given limit in the initial time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * <p>
         * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         * </p>
         * 
         * @param period
         *        The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         * @see QuotaPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuotaPeriodType
         */
        Builder period(String period);

        /**
         * <p>
         * The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         * </p>
         * 
         * @param period
         *        The time period in which the limit applies. Valid values are "DAY", "WEEK" or "MONTH".
         * @see QuotaPeriodType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QuotaPeriodType
         */
        Builder period(QuotaPeriodType period);
    }

    static final class BuilderImpl implements Builder {
        private Integer limit;

        private Integer offset;

        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaSettings model) {
            limit(model.limit);
            offset(model.offset);
            period(model.period);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Integer getOffset() {
            return offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        public final String getPeriod() {
            return period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(QuotaPeriodType period) {
            this.period(period.toString());
            return this;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public QuotaSettings build() {
            return new QuotaSettings(this);
        }
    }
}
