/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The requested service is not available. For details see the accompanying error message. Retry after the specified
 * time period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceUnavailableException extends ApiGatewayException implements
        ToCopyableBuilder<ServiceUnavailableException.Builder, ServiceUnavailableException> {
    private final String retryAfterSeconds;

    private ServiceUnavailableException(BuilderImpl builder) {
        super(builder);
        this.retryAfterSeconds = builder.retryAfterSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the RetryAfterSeconds property for this object.
     * 
     * @return The value of the RetryAfterSeconds property for this object.
     */
    public String retryAfterSeconds() {
        return retryAfterSeconds;
    }

    public interface Builder extends CopyableBuilder<Builder, ServiceUnavailableException>, ApiGatewayException.Builder {
        /**
         * Sets the value of the RetryAfterSeconds property for this object.
         *
         * @param retryAfterSeconds
         *        The new value for the RetryAfterSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(String retryAfterSeconds);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends ApiGatewayException.BuilderImpl implements Builder {
        private String retryAfterSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUnavailableException model) {
            super(model);
            retryAfterSeconds(model.retryAfterSeconds);
        }

        public final String getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @JsonProperty("Retry-After")
        public final void setRetryAfterSeconds(String retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceUnavailableException build() {
            return new ServiceUnavailableException(this);
        }
    }
}
