/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.StageKeyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a unique stage identified in the format <code>{restApiId}/{stage}</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageKey implements StructuredPojo, ToCopyableBuilder<StageKey.Builder, StageKey> {
    private final String restApiId;

    private final String stageName;

    private StageKey(BuilderImpl builder) {
        this.restApiId = builder.restApiId;
        this.stageName = builder.stageName;
    }

    /**
     * <p>
     * The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The stage name associated with the stage key.
     * </p>
     * 
     * @return The stage name associated with the stage key.
     */
    public String stageName() {
        return stageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageKey)) {
            return false;
        }
        StageKey other = (StageKey) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(stageName(), other.stageName());
    }

    @Override
    public String toString() {
        return ToString.builder("StageKey").add("RestApiId", restApiId()).add("StageName", stageName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StageKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StageKey> {
        /**
         * <p>
         * The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The stage name associated with the stage key.
         * </p>
         * 
         * @param stageName
         *        The stage name associated with the stage key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);
    }

    static final class BuilderImpl implements Builder {
        private String restApiId;

        private String stageName;

        private BuilderImpl() {
        }

        private BuilderImpl(StageKey model) {
            restApiId(model.restApiId);
            stageName(model.stageName);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStageName() {
            return stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public StageKey build() {
            return new StageKey(this);
        }
    }
}
