/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response of the test invoke request for a custom <a>Authorizer</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<TestInvokeAuthorizerResponse.Builder, TestInvokeAuthorizerResponse> {
    private final Integer clientStatus;

    private final String log;

    private final Long latency;

    private final String principalId;

    private final String policy;

    private final Map<String, List<String>> authorization;

    private final Map<String, String> claims;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.clientStatus = builder.clientStatus;
        this.log = builder.log;
        this.latency = builder.latency;
        this.principalId = builder.principalId;
        this.policy = builder.policy;
        this.authorization = builder.authorization;
        this.claims = builder.claims;
    }

    /**
     * <p>
     * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     * </p>
     * 
     * @return The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     */
    public Integer clientStatus() {
        return clientStatus;
    }

    /**
     * <p>
     * The API Gateway execution log for the test authorizer request.
     * </p>
     * 
     * @return The API Gateway execution log for the test authorizer request.
     */
    public String log() {
        return log;
    }

    /**
     * <p>
     * The execution latency of the test authorizer request.
     * </p>
     * 
     * @return The execution latency of the test authorizer request.
     */
    public Long latency() {
        return latency;
    }

    /**
     * <p>
     * The principal identity returned by the <a>Authorizer</a>
     * </p>
     * 
     * @return The principal identity returned by the <a>Authorizer</a>
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The JSON policy document returned by the <a>Authorizer</a>
     * </p>
     * 
     * @return The JSON policy document returned by the <a>Authorizer</a>
     */
    public String policy() {
        return policy;
    }

    /**
     * Returns the value of the Authorization property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Authorization property for this object.
     */
    public Map<String, List<String>> authorization() {
        return authorization;
    }

    /**
     * <p>
     * The <a href="http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>, with
     * any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The <a href="http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity
     *         claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured for
     *         the API.
     */
    public Map<String, String> claims() {
        return claims;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientStatus());
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(latency());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(authorization());
        hashCode = 31 * hashCode + Objects.hashCode(claims());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse) obj;
        return Objects.equals(clientStatus(), other.clientStatus()) && Objects.equals(log(), other.log())
                && Objects.equals(latency(), other.latency()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(policy(), other.policy()) && Objects.equals(authorization(), other.authorization())
                && Objects.equals(claims(), other.claims());
    }

    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerResponse").add("ClientStatus", clientStatus()).add("Log", log())
                .add("Latency", latency()).add("PrincipalId", principalId()).add("Policy", policy())
                .add("Authorization", authorization()).add("Claims", claims()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientStatus":
            return Optional.ofNullable(clazz.cast(clientStatus()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "latency":
            return Optional.ofNullable(clazz.cast(latency()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "authorization":
            return Optional.ofNullable(clazz.cast(authorization()));
        case "claims":
            return Optional.ofNullable(clazz.cast(claims()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        /**
         * <p>
         * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         * </p>
         * 
         * @param clientStatus
         *        The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientStatus(Integer clientStatus);

        /**
         * <p>
         * The API Gateway execution log for the test authorizer request.
         * </p>
         * 
         * @param log
         *        The API Gateway execution log for the test authorizer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(String log);

        /**
         * <p>
         * The execution latency of the test authorizer request.
         * </p>
         * 
         * @param latency
         *        The execution latency of the test authorizer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latency(Long latency);

        /**
         * <p>
         * The principal identity returned by the <a>Authorizer</a>
         * </p>
         * 
         * @param principalId
         *        The principal identity returned by the <a>Authorizer</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The JSON policy document returned by the <a>Authorizer</a>
         * </p>
         * 
         * @param policy
         *        The JSON policy document returned by the <a>Authorizer</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * Sets the value of the Authorization property for this object.
         *
         * @param authorization
         *        The new value for the Authorization property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorization(Map<String, ? extends Collection<String>> authorization);

        /**
         * <p>
         * The <a href="http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity claims</a>,
         * with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
         * </p>
         * 
         * @param claims
         *        The <a href="http://openid.net/specs/openid-connect-core-1_0.html#StandardClaims">open identity
         *        claims</a>, with any supported custom attributes, returned from the Cognito Your User Pool configured
         *        for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(Map<String, String> claims);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private Integer clientStatus;

        private String log;

        private Long latency;

        private String principalId;

        private String policy;

        private Map<String, List<String>> authorization = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> claims = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            clientStatus(model.clientStatus);
            log(model.log);
            latency(model.latency);
            principalId(model.principalId);
            policy(model.policy);
            authorization(model.authorization);
            claims(model.claims);
        }

        public final Integer getClientStatus() {
            return clientStatus;
        }

        @Override
        public final Builder clientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
            return this;
        }

        public final void setClientStatus(Integer clientStatus) {
            this.clientStatus = clientStatus;
        }

        public final String getLog() {
            return log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        public final Long getLatency() {
            return latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final Map<String, ? extends Collection<String>> getAuthorization() {
            return authorization;
        }

        @Override
        public final Builder authorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
            return this;
        }

        public final void setAuthorization(Map<String, ? extends Collection<String>> authorization) {
            this.authorization = MapOfStringToListCopier.copy(authorization);
        }

        public final Map<String, String> getClaims() {
            return claims;
        }

        @Override
        public final Builder claims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
            return this;
        }

        public final void setClaims(Map<String, String> claims) {
            this.claims = MapOfStringToStringCopier.copy(claims);
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }
    }
}
