/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.ThrottleSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The API request rate limits.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottleSettings implements StructuredPojo, ToCopyableBuilder<ThrottleSettings.Builder, ThrottleSettings> {
    private final Integer burstLimit;

    private final Double rateLimit;

    private ThrottleSettings(BuilderImpl builder) {
        this.burstLimit = builder.burstLimit;
        this.rateLimit = builder.rateLimit;
    }

    /**
     * <p>
     * The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending upon
     * whether the underlying token bucket is at its full capacity.
     * </p>
     * 
     * @return The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds,
     *         depending upon whether the underlying token bucket is at its full capacity.
     */
    public Integer burstLimit() {
        return burstLimit;
    }

    /**
     * <p>
     * The API request steady-state rate limit.
     * </p>
     * 
     * @return The API request steady-state rate limit.
     */
    public Double rateLimit() {
        return rateLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(burstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThrottleSettings)) {
            return false;
        }
        ThrottleSettings other = (ThrottleSettings) obj;
        return Objects.equals(burstLimit(), other.burstLimit()) && Objects.equals(rateLimit(), other.rateLimit());
    }

    @Override
    public String toString() {
        return ToString.builder("ThrottleSettings").add("BurstLimit", burstLimit()).add("RateLimit", rateLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "burstLimit":
            return Optional.ofNullable(clazz.cast(burstLimit()));
        case "rateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThrottleSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ThrottleSettings> {
        /**
         * <p>
         * The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds, depending
         * upon whether the underlying token bucket is at its full capacity.
         * </p>
         * 
         * @param burstLimit
         *        The API request burst limit, the maximum rate limit over a time ranging from one to a few seconds,
         *        depending upon whether the underlying token bucket is at its full capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burstLimit(Integer burstLimit);

        /**
         * <p>
         * The API request steady-state rate limit.
         * </p>
         * 
         * @param rateLimit
         *        The API request steady-state rate limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Double rateLimit);
    }

    static final class BuilderImpl implements Builder {
        private Integer burstLimit;

        private Double rateLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottleSettings model) {
            burstLimit(model.burstLimit);
            rateLimit(model.rateLimit);
        }

        public final Integer getBurstLimit() {
            return burstLimit;
        }

        @Override
        public final Builder burstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
            return this;
        }

        public final void setBurstLimit(Integer burstLimit) {
            this.burstLimit = burstLimit;
        }

        public final Double getRateLimit() {
            return rateLimit;
        }

        @Override
        public final Builder rateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final void setRateLimit(Double rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public ThrottleSettings build() {
            return new ThrottleSettings(this);
        }
    }
}
