/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource that can be distributed to callers for executing <a>Method</a> resources that require an API key. API keys
 * can be mapped to any <a>Stage</a> on any <a>RestApi</a>, which indicates that the callers with the API key can make
 * requests to that stage.
 * </p>
 * <div class="seeAlso"> <a href="http://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html">Use
 * API Keys</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApiKeyResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<UpdateApiKeyResponse.Builder, UpdateApiKeyResponse> {
    private final String id;

    private final String value;

    private final String name;

    private final String customerId;

    private final String description;

    private final Boolean enabled;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private final List<String> stageKeys;

    private UpdateApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.value = builder.value;
        this.name = builder.name;
        this.customerId = builder.customerId;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.stageKeys = builder.stageKeys;
    }

    /**
     * <p>
     * The identifier of the API Key.
     * </p>
     * 
     * @return The identifier of the API Key.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the API Key.
     * </p>
     * 
     * @return The value of the API Key.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * The name of the API Key.
     * </p>
     * 
     * @return The name of the API Key.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     * </p>
     * 
     * @return An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    public String customerId() {
        return customerId;
    }

    /**
     * <p>
     * The description of the API Key.
     * </p>
     * 
     * @return The description of the API Key.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the API Key can be used by callers.
     * </p>
     * 
     * @return Specifies whether the API Key can be used by callers.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The timestamp when the API Key was created.
     * </p>
     * 
     * @return The timestamp when the API Key was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp when the API Key was last updated.
     * </p>
     * 
     * @return The timestamp when the API Key was last updated.
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
     */
    public List<String> stageKeys() {
        return stageKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(customerId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(stageKeys());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiKeyResponse)) {
            return false;
        }
        UpdateApiKeyResponse other = (UpdateApiKeyResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(value(), other.value()) && Objects.equals(name(), other.name())
                && Objects.equals(customerId(), other.customerId()) && Objects.equals(description(), other.description())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(stageKeys(), other.stageKeys());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateApiKeyResponse").add("Id", id()).add("Value", value()).add("Name", name())
                .add("CustomerId", customerId()).add("Description", description()).add("Enabled", enabled())
                .add("CreatedDate", createdDate()).add("LastUpdatedDate", lastUpdatedDate()).add("StageKeys", stageKeys())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "customerId":
            return Optional.ofNullable(clazz.cast(customerId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "stageKeys":
            return Optional.ofNullable(clazz.cast(stageKeys()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, UpdateApiKeyResponse> {
        /**
         * <p>
         * The identifier of the API Key.
         * </p>
         * 
         * @param id
         *        The identifier of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the API Key.
         * </p>
         * 
         * @param value
         *        The value of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The name of the API Key.
         * </p>
         * 
         * @param name
         *        The name of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * </p>
         * 
         * @param customerId
         *        An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerId(String customerId);

        /**
         * <p>
         * The description of the API Key.
         * </p>
         * 
         * @param description
         *        The description of the API Key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the API Key can be used by callers.
         * </p>
         * 
         * @param enabled
         *        Specifies whether the API Key can be used by callers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The timestamp when the API Key was created.
         * </p>
         * 
         * @param createdDate
         *        The timestamp when the API Key was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The timestamp when the API Key was last updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The timestamp when the API Key was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * </p>
         * 
         * @param stageKeys
         *        A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(Collection<String> stageKeys);

        /**
         * <p>
         * A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * </p>
         * 
         * @param stageKeys
         *        A list of <a>Stage</a> resources that are associated with the <a>ApiKey</a> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageKeys(String... stageKeys);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String value;

        private String name;

        private String customerId;

        private String description;

        private Boolean enabled;

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private List<String> stageKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiKeyResponse model) {
            super(model);
            id(model.id);
            value(model.value);
            name(model.name);
            customerId(model.customerId);
            description(model.description);
            enabled(model.enabled);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            stageKeys(model.stageKeys);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCustomerId() {
            return customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Collection<String> getStageKeys() {
            return stageKeys;
        }

        @Override
        public final Builder stageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(String... stageKeys) {
            stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        public final void setStageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
        }

        @Override
        public UpdateApiKeyResponse build() {
            return new UpdateApiKeyResponse(this);
        }
    }
}
