/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An immutable representation of a <a>RestApi</a> resource that can be called by users using <a>Stages</a>. A
 * deployment must be associated with a <a>Stage</a> for it to be callable over the Internet.
 * </p>
 * <div class="remarks">To create a deployment, call <code>POST</code> on the <a>Deployments</a> resource of a
 * <a>RestApi</a>. To view, update, or delete a deployment, call <code>GET</code>, <code>PATCH</code>, or
 * <code>DELETE</code> on the specified deployment resource (
 * <code>/restapis/{restapi_id}/deployments/{deployment_id}</code>).</div> <div class="seeAlso"><a>RestApi</a>,
 * <a>Deployments</a>, <a>Stage</a>, <a
 * href="http://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html">AWS CLI</a>, <a
 * href="https://aws.amazon.com/tools/">AWS SDKs</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeploymentResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<UpdateDeploymentResponse.Builder, UpdateDeploymentResponse> {
    private final String id;

    private final String description;

    private final Instant createdDate;

    private final Map<String, Map<String, MethodSnapshot>> apiSummary;

    private UpdateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.apiSummary = builder.apiSummary;
    }

    /**
     * <p>
     * The identifier for the deployment resource.
     * </p>
     * 
     * @return The identifier for the deployment resource.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The description for the deployment resource.
     * </p>
     * 
     * @return The description for the deployment resource.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that the deployment resource was created.
     * </p>
     * 
     * @return The date and time that the deployment resource was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
     */
    public Map<String, Map<String, MethodSnapshot>> apiSummary() {
        return apiSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(apiSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentResponse)) {
            return false;
        }
        UpdateDeploymentResponse other = (UpdateDeploymentResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(apiSummary(), other.apiSummary());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDeploymentResponse").add("Id", id()).add("Description", description())
                .add("CreatedDate", createdDate()).add("ApiSummary", apiSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "apiSummary":
            return Optional.ofNullable(clazz.cast(apiSummary()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, UpdateDeploymentResponse> {
        /**
         * <p>
         * The identifier for the deployment resource.
         * </p>
         * 
         * @param id
         *        The identifier for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description for the deployment resource.
         * </p>
         * 
         * @param description
         *        The description for the deployment resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that the deployment resource was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
         * </p>
         * 
         * @param apiSummary
         *        A summary of the <a>RestApi</a> at the date and time that the deployment resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String id;

        private String description;

        private Instant createdDate;

        private Map<String, Map<String, MethodSnapshot>> apiSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentResponse model) {
            super(model);
            id(model.id);
            description(model.description);
            createdDate(model.createdDate);
            apiSummary(model.apiSummary);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Map<String, Map<String, MethodSnapshot>> getApiSummary() {
            return apiSummary;
        }

        @Override
        public final Builder apiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copy(apiSummary);
            return this;
        }

        public final void setApiSummary(Map<String, Map<String, MethodSnapshot>> apiSummary) {
            this.apiSummary = PathToMapOfMethodSnapshotCopier.copy(apiSummary);
        }

        @Override
        public UpdateDeploymentResponse build() {
            return new UpdateDeploymentResponse(this);
        }
    }
}
