/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates a <a>RequestValidator</a> of a given <a>RestApi</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRequestValidatorRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<UpdateRequestValidatorRequest.Builder, UpdateRequestValidatorRequest> {
    private final String restApiId;

    private final String requestValidatorId;

    private final List<PatchOperation> patchOperations;

    private UpdateRequestValidatorRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.requestValidatorId = builder.requestValidatorId;
        this.patchOperations = builder.patchOperations;
    }

    /**
     * <p>
     * [Required] The string identifier of the associated <a>RestApi</a>.
     * </p>
     * 
     * @return [Required] The string identifier of the associated <a>RestApi</a>.
     */
    public String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * [Required] The identifier of <a>RequestValidator</a> to be updated.
     * </p>
     * 
     * @return [Required] The identifier of <a>RequestValidator</a> to be updated.
     */
    public String requestValidatorId() {
        return requestValidatorId;
    }

    /**
     * <p>
     * A list of update operations to be applied to the specified resource and in the order specified in this list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of update operations to be applied to the specified resource and in the order specified in this
     *         list.
     */
    public List<PatchOperation> patchOperations() {
        return patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(requestValidatorId());
        hashCode = 31 * hashCode + Objects.hashCode(patchOperations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRequestValidatorRequest)) {
            return false;
        }
        UpdateRequestValidatorRequest other = (UpdateRequestValidatorRequest) obj;
        return Objects.equals(restApiId(), other.restApiId()) && Objects.equals(requestValidatorId(), other.requestValidatorId())
                && Objects.equals(patchOperations(), other.patchOperations());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateRequestValidatorRequest").add("RestApiId", restApiId())
                .add("RequestValidatorId", requestValidatorId()).add("PatchOperations", patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "requestValidatorId":
            return Optional.ofNullable(clazz.cast(requestValidatorId()));
        case "patchOperations":
            return Optional.ofNullable(clazz.cast(patchOperations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayRequest.Builder, CopyableBuilder<Builder, UpdateRequestValidatorRequest> {
        /**
         * <p>
         * [Required] The string identifier of the associated <a>RestApi</a>.
         * </p>
         * 
         * @param restApiId
         *        [Required] The string identifier of the associated <a>RestApi</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * [Required] The identifier of <a>RequestValidator</a> to be updated.
         * </p>
         * 
         * @param requestValidatorId
         *        [Required] The identifier of <a>RequestValidator</a> to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestValidatorId(String requestValidatorId);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(Collection<PatchOperation> patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * 
         * @param patchOperations
         *        A list of update operations to be applied to the specified resource and in the order specified in this
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchOperations(PatchOperation... patchOperations);

        /**
         * <p>
         * A list of update operations to be applied to the specified resource and in the order specified in this list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PatchOperation>.Builder} avoiding the need
         * to create one manually via {@link List<PatchOperation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchOperation>.Builder#build()} is called immediately and
         * its result is passed to {@link #patchOperations(List<PatchOperation>)}.
         * 
         * @param patchOperations
         *        a consumer that will call methods on {@link List<PatchOperation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchOperations(List<PatchOperation>)
         */
        Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String requestValidatorId;

        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRequestValidatorRequest model) {
            super(model);
            restApiId(model.restApiId);
            requestValidatorId(model.requestValidatorId);
            patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getRequestValidatorId() {
            return requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return patchOperations != null ? patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation... patchOperations) {
            patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder>... patchOperations) {
            patchOperations(Stream.of(patchOperations).map(c -> PatchOperation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRequestValidatorRequest build() {
            return new UpdateRequestValidatorRequest(this);
        }
    }
}
