/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the usage data of a usage plan.
 * </p>
 * <div class="remarks"/> <div class="seeAlso"> <a
 * href="http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html">Create and Use
 * Usage Plans</a>, <a href=
 * "http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-usage-plans-with-console.html#api-gateway-usage-plan-manage-usage"
 * >Manage Usage in a Usage Plan</a> </div>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUsageResponse extends ApiGatewayResponse implements
        ToCopyableBuilder<UpdateUsageResponse.Builder, UpdateUsageResponse> {
    private final String usagePlanId;

    private final String startDate;

    private final String endDate;

    private final String position;

    private final Map<String, List<List<Long>>> items;

    private UpdateUsageResponse(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.position = builder.position;
        this.items = builder.items;
    }

    /**
     * <p>
     * The plan Id associated with this usage data.
     * </p>
     * 
     * @return The plan Id associated with this usage data.
     */
    public String usagePlanId() {
        return usagePlanId;
    }

    /**
     * <p>
     * The starting date of the usage data.
     * </p>
     * 
     * @return The starting date of the usage data.
     */
    public String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The ending date of the usage data.
     * </p>
     * 
     * @return The ending date of the usage data.
     */
    public String endDate() {
        return endDate;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public String position() {
        return position;
    }

    /**
     * <p>
     * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the API
     * keys in a usage plan. For example,
     * <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code>
     * stands for an API key value and the daily log entry is of the format <code>[used quota, remaining quota]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over
     *         the API keys in a usage plan. For example,
     *         <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where
     *         <code>{api_key}</code> stands for an API key value and the daily log entry is of the format
     *         <code>[used quota, remaining quota]</code>.
     */
    public Map<String, List<List<Long>>> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsageResponse)) {
            return false;
        }
        UpdateUsageResponse other = (UpdateUsageResponse) obj;
        return Objects.equals(usagePlanId(), other.usagePlanId()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(position(), other.position())
                && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateUsageResponse").add("UsagePlanId", usagePlanId()).add("StartDate", startDate())
                .add("EndDate", endDate()).add("Position", position()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usagePlanId":
            return Optional.ofNullable(clazz.cast(usagePlanId()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ApiGatewayResponse.Builder, CopyableBuilder<Builder, UpdateUsageResponse> {
        /**
         * <p>
         * The plan Id associated with this usage data.
         * </p>
         * 
         * @param usagePlanId
         *        The plan Id associated with this usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePlanId(String usagePlanId);

        /**
         * <p>
         * The starting date of the usage data.
         * </p>
         * 
         * @param startDate
         *        The starting date of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The ending date of the usage data.
         * </p>
         * 
         * @param endDate
         *        The ending date of the usage data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(String position);

        /**
         * <p>
         * The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed over the
         * API keys in a usage plan. For example,
         * <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where <code>{api_key}</code>
         * stands for an API key value and the daily log entry is of the format
         * <code>[used quota, remaining quota]</code>.
         * </p>
         * 
         * @param items
         *        The usage data, as daily logs of used and remaining quotas, over the specified time interval indexed
         *        over the API keys in a usage plan. For example,
         *        <code>{..., "values" : { "{api_key}" : [ [0, 100], [10, 90], [100, 10]]}</code>, where
         *        <code>{api_key}</code> stands for an API key value and the daily log entry is of the format
         *        <code>[used quota, remaining quota]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items);
    }

    static final class BuilderImpl extends ApiGatewayResponse.BuilderImpl implements Builder {
        private String usagePlanId;

        private String startDate;

        private String endDate;

        private String position;

        private Map<String, List<List<Long>>> items = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsageResponse model) {
            super(model);
            usagePlanId(model.usagePlanId);
            startDate(model.startDate);
            endDate(model.endDate);
            position(model.position);
            items(model.items);
        }

        public final String getUsagePlanId() {
            return usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getPosition() {
            return position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Map<String, ? extends Collection<? extends Collection<Long>>> getItems() {
            return items;
        }

        @Override
        public final Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
            return this;
        }

        public final void setItems(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
        }

        @Override
        public UpdateUsageResponse build() {
            return new UpdateUsageResponse(this);
        }
    }
}
