/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ClientCertificate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ClientCertificate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ClientCertificateMarshaller {
    private static final MarshallingInfo<String> CLIENTCERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCertificateId").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<String> PEMENCODEDCERTIFICATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pemEncodedCertificate").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> EXPIRATIONDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expirationDate").isBinary(false).build();

    private static final ClientCertificateMarshaller INSTANCE = new ClientCertificateMarshaller();

    private ClientCertificateMarshaller() {
    }

    public static ClientCertificateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ClientCertificate clientCertificate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(clientCertificate, "clientCertificate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(clientCertificate.clientCertificateId(), CLIENTCERTIFICATEID_BINDING);
            protocolMarshaller.marshall(clientCertificate.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(clientCertificate.pemEncodedCertificate(), PEMENCODEDCERTIFICATE_BINDING);
            protocolMarshaller.marshall(clientCertificate.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(clientCertificate.expirationDate(), EXPIRATIONDATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
