/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateAuthorizerRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateAuthorizerRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateAuthorizerRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<List> PROVIDERARNS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerARNs").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authType").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZERURI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerUri").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZERCREDENTIALS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerCredentials").isBinary(false).build();

    private static final MarshallingInfo<String> IDENTITYSOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identitySource").isBinary(false).build();

    private static final MarshallingInfo<String> IDENTITYVALIDATIONEXPRESSION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("identityValidationExpression").isBinary(false).build();

    private static final MarshallingInfo<Integer> AUTHORIZERRESULTTTLINSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("authorizerResultTtlInSeconds").isBinary(false).build();

    private static final CreateAuthorizerRequestModelMarshaller INSTANCE = new CreateAuthorizerRequestModelMarshaller();

    private CreateAuthorizerRequestModelMarshaller() {
    }

    public static CreateAuthorizerRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateAuthorizerRequest createAuthorizerRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createAuthorizerRequest, "createAuthorizerRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createAuthorizerRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.providerARNs(), PROVIDERARNS_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.authType(), AUTHTYPE_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.authorizerUri(), AUTHORIZERURI_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.authorizerCredentials(), AUTHORIZERCREDENTIALS_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.identitySource(), IDENTITYSOURCE_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.identityValidationExpression(),
                    IDENTITYVALIDATIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(createAuthorizerRequest.authorizerResultTtlInSeconds(),
                    AUTHORIZERRESULTTTLINSECONDS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
