/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateBasePathMappingRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateBasePathMappingRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateBasePathMappingRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("domain_name").isBinary(false).build();

    private static final MarshallingInfo<String> BASEPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("basePath").isBinary(false).build();

    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restApiId").isBinary(false).build();

    private static final MarshallingInfo<String> STAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stage").isBinary(false).build();

    private static final CreateBasePathMappingRequestModelMarshaller INSTANCE = new CreateBasePathMappingRequestModelMarshaller();

    private CreateBasePathMappingRequestModelMarshaller() {
    }

    public static CreateBasePathMappingRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateBasePathMappingRequest createBasePathMappingRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createBasePathMappingRequest, "createBasePathMappingRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createBasePathMappingRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(createBasePathMappingRequest.basePath(), BASEPATH_BINDING);
            protocolMarshaller.marshall(createBasePathMappingRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall(createBasePathMappingRequest.stage(), STAGE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
