/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.CreateDomainNameRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CreateDomainNameRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CreateDomainNameRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEBODY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateBody").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEPRIVATEKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePrivateKey").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATECHAIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateChain").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALCERTIFICATENAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("regionalCertificateName").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALCERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateArn").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("endpointConfiguration").isBinary(false).build();

    private static final CreateDomainNameRequestModelMarshaller INSTANCE = new CreateDomainNameRequestModelMarshaller();

    private CreateDomainNameRequestModelMarshaller() {
    }

    public static CreateDomainNameRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CreateDomainNameRequest createDomainNameRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(createDomainNameRequest, "createDomainNameRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(createDomainNameRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.certificateBody(), CERTIFICATEBODY_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.certificatePrivateKey(), CERTIFICATEPRIVATEKEY_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.certificateChain(), CERTIFICATECHAIN_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.regionalCertificateName(), REGIONALCERTIFICATENAME_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.regionalCertificateArn(), REGIONALCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(createDomainNameRequest.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
