/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateDomainNameResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateDomainNameResponseUnmarshaller implements Unmarshaller<CreateDomainNameResponse, JsonUnmarshallerContext> {

    public CreateDomainNameResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateDomainNameResponse.Builder createDomainNameResponseBuilder = CreateDomainNameResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createDomainNameResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("domainName", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.domainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateName", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.certificateName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateArn", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.certificateArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateUploadDate", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.certificateUploadDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("regionalDomainName", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.regionalDomainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("regionalHostedZoneId", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.regionalHostedZoneId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("regionalCertificateName", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.regionalCertificateName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("regionalCertificateArn", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.regionalCertificateArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("distributionDomainName", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.distributionDomainName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("distributionHostedZoneId", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.distributionHostedZoneId(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("endpointConfiguration", targetDepth)) {
                    context.nextToken();
                    createDomainNameResponseBuilder.endpointConfiguration(EndpointConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createDomainNameResponseBuilder.build();
    }

    private static final CreateDomainNameResponseUnmarshaller INSTANCE = new CreateDomainNameResponseUnmarshaller();

    public static CreateDomainNameResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
