/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateRequestValidatorResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateRequestValidatorResponseUnmarshaller implements
        Unmarshaller<CreateRequestValidatorResponse, JsonUnmarshallerContext> {

    public CreateRequestValidatorResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateRequestValidatorResponse.Builder createRequestValidatorResponseBuilder = CreateRequestValidatorResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createRequestValidatorResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    createRequestValidatorResponseBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    createRequestValidatorResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("validateRequestBody", targetDepth)) {
                    context.nextToken();
                    createRequestValidatorResponseBuilder.validateRequestBody(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
                if (context.testExpression("validateRequestParameters", targetDepth)) {
                    context.nextToken();
                    createRequestValidatorResponseBuilder.validateRequestParameters(context.getUnmarshaller(Boolean.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createRequestValidatorResponseBuilder.build();
    }

    private static final CreateRequestValidatorResponseUnmarshaller INSTANCE = new CreateRequestValidatorResponseUnmarshaller();

    public static CreateRequestValidatorResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
