/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DeleteResourceResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteResourceResponseUnmarshaller implements Unmarshaller<DeleteResourceResponse, JsonUnmarshallerContext> {

    public DeleteResourceResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DeleteResourceResponse.Builder deleteResourceResponseBuilder = DeleteResourceResponse.builder();

        return deleteResourceResponseBuilder.build();
    }

    private static final DeleteResourceResponseUnmarshaller INSTANCE = new DeleteResourceResponseUnmarshaller();

    public static DeleteResourceResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
