/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DeploymentCanarySettings} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DeploymentCanarySettingsMarshaller {
    private static final MarshallingInfo<Double> PERCENTTRAFFIC_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentTraffic").isBinary(false).build();

    private static final MarshallingInfo<Map> STAGEVARIABLEOVERRIDES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageVariableOverrides").isBinary(false).build();

    private static final MarshallingInfo<Boolean> USESTAGECACHE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useStageCache").isBinary(false).build();

    private static final DeploymentCanarySettingsMarshaller INSTANCE = new DeploymentCanarySettingsMarshaller();

    private DeploymentCanarySettingsMarshaller() {
    }

    public static DeploymentCanarySettingsMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DeploymentCanarySettings deploymentCanarySettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(deploymentCanarySettings, "deploymentCanarySettings");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(deploymentCanarySettings.percentTraffic(), PERCENTTRAFFIC_BINDING);
            protocolMarshaller.marshall(deploymentCanarySettings.stageVariableOverrides(), STAGEVARIABLEOVERRIDES_BINDING);
            protocolMarshaller.marshall(deploymentCanarySettings.useStageCache(), USESTAGECACHE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
