/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.DomainName;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DomainName} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DomainNameMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("domainName").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateName").isBinary(false).build();

    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();

    private static final MarshallingInfo<Instant> CERTIFICATEUPLOADDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("certificateUploadDate").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALDOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalDomainName").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALHOSTEDZONEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalHostedZoneId").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALCERTIFICATENAME_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("regionalCertificateName").isBinary(false).build();

    private static final MarshallingInfo<String> REGIONALCERTIFICATEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionalCertificateArn").isBinary(false).build();

    private static final MarshallingInfo<String> DISTRIBUTIONDOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("distributionDomainName").isBinary(false).build();

    private static final MarshallingInfo<String> DISTRIBUTIONHOSTEDZONEID_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("distributionHostedZoneId").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ENDPOINTCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("endpointConfiguration").isBinary(false).build();

    private static final DomainNameMarshaller INSTANCE = new DomainNameMarshaller();

    private DomainNameMarshaller() {
    }

    public static DomainNameMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DomainName domainName, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(domainName, "domainName");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(domainName.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainName.certificateName(), CERTIFICATENAME_BINDING);
            protocolMarshaller.marshall(domainName.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(domainName.certificateUploadDate(), CERTIFICATEUPLOADDATE_BINDING);
            protocolMarshaller.marshall(domainName.regionalDomainName(), REGIONALDOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainName.regionalHostedZoneId(), REGIONALHOSTEDZONEID_BINDING);
            protocolMarshaller.marshall(domainName.regionalCertificateName(), REGIONALCERTIFICATENAME_BINDING);
            protocolMarshaller.marshall(domainName.regionalCertificateArn(), REGIONALCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall(domainName.distributionDomainName(), DISTRIBUTIONDOMAINNAME_BINDING);
            protocolMarshaller.marshall(domainName.distributionHostedZoneId(), DISTRIBUTIONHOSTEDZONEID_BINDING);
            protocolMarshaller.marshall(domainName.endpointConfiguration(), ENDPOINTCONFIGURATION_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
