/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;
import software.amazon.awssdk.core.SdkBytes;
import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetExportResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetExportResponseUnmarshaller implements Unmarshaller<GetExportResponse, JsonUnmarshallerContext> {

    public GetExportResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetExportResponse.Builder getExportResponseBuilder = GetExportResponse.builder();

        if (context.isStartOfDocument()) {
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getExportResponseBuilder.contentType(context.getUnmarshaller(String.class).unmarshall(context));
            }
            if (context.getHeader("Content-Disposition") != null) {
                context.setCurrentHeader("Content-Disposition");
                getExportResponseBuilder.contentDisposition(context.getUnmarshaller(String.class).unmarshall(context));
            }
        }

        java.io.InputStream is = context.getHttpResponse().content().orElse(null);
        if (is != null) {
            try {
                getExportResponseBuilder.body(software.amazon.awssdk.core.SdkBytes.fromInputStream(is));
            } finally {
                software.amazon.awssdk.utils.IoUtils.closeQuietly(is, null);
            }
        }

        return getExportResponseBuilder.build();
    }

    private static final GetExportResponseUnmarshaller INSTANCE = new GetExportResponseUnmarshaller();

    public static GetExportResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
