/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Integration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class IntegrationMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").isBinary(false).build();

    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").isBinary(false).build();

    private static final MarshallingInfo<String> CONNECTIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionType").isBinary(false).build();

    private static final MarshallingInfo<String> CONNECTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("connectionId").isBinary(false).build();

    private static final MarshallingInfo<String> CREDENTIALS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("credentials").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTTEMPLATES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestTemplates").isBinary(false).build();

    private static final MarshallingInfo<String> PASSTHROUGHBEHAVIOR_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughBehavior").isBinary(false).build();

    private static final MarshallingInfo<String> CONTENTHANDLING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentHandling").isBinary(false).build();

    private static final MarshallingInfo<Integer> TIMEOUTINMILLIS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeoutInMillis").isBinary(false).build();

    private static final MarshallingInfo<String> CACHENAMESPACE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheNamespace").isBinary(false).build();

    private static final MarshallingInfo<List> CACHEKEYPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheKeyParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> INTEGRATIONRESPONSES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("integrationResponses").isBinary(false).build();

    private static final IntegrationMarshaller INSTANCE = new IntegrationMarshaller();

    private IntegrationMarshaller() {
    }

    public static IntegrationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Integration integration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(integration, "integration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(integration.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(integration.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(integration.uri(), URI_BINDING);
            protocolMarshaller.marshall(integration.connectionTypeAsString(), CONNECTIONTYPE_BINDING);
            protocolMarshaller.marshall(integration.connectionId(), CONNECTIONID_BINDING);
            protocolMarshaller.marshall(integration.credentials(), CREDENTIALS_BINDING);
            protocolMarshaller.marshall(integration.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(integration.requestTemplates(), REQUESTTEMPLATES_BINDING);
            protocolMarshaller.marshall(integration.passthroughBehavior(), PASSTHROUGHBEHAVIOR_BINDING);
            protocolMarshaller.marshall(integration.contentHandlingAsString(), CONTENTHANDLING_BINDING);
            protocolMarshaller.marshall(integration.timeoutInMillis(), TIMEOUTINMILLIS_BINDING);
            protocolMarshaller.marshall(integration.cacheNamespace(), CACHENAMESPACE_BINDING);
            protocolMarshaller.marshall(integration.cacheKeyParameters(), CACHEKEYPARAMETERS_BINDING);
            protocolMarshaller.marshall(integration.integrationResponses(), INTEGRATIONRESPONSES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
