/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.IntegrationResponse;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link IntegrationResponse} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class IntegrationResponseMarshaller {
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();

    private static final MarshallingInfo<String> SELECTIONPATTERN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("selectionPattern").isBinary(false).build();

    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> RESPONSETEMPLATES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseTemplates").isBinary(false).build();

    private static final MarshallingInfo<String> CONTENTHANDLING_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentHandling").isBinary(false).build();

    private static final IntegrationResponseMarshaller INSTANCE = new IntegrationResponseMarshaller();

    private IntegrationResponseMarshaller() {
    }

    public static IntegrationResponseMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(IntegrationResponse integrationResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(integrationResponse, "integrationResponse");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(integrationResponse.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(integrationResponse.selectionPattern(), SELECTIONPATTERN_BINDING);
            protocolMarshaller.marshall(integrationResponse.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(integrationResponse.responseTemplates(), RESPONSETEMPLATES_BINDING);
            protocolMarshaller.marshall(integrationResponse.contentHandlingAsString(), CONTENTHANDLING_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
