/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.Method;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Method} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MethodMarshaller {
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").isBinary(false).build();

    private static final MarshallingInfo<String> REQUESTVALIDATORID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestValidatorId").isBinary(false).build();

    private static final MarshallingInfo<String> OPERATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationName").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTMODELS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestModels").isBinary(false).build();

    private static final MarshallingInfo<Map> METHODRESPONSES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodResponses").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> METHODINTEGRATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("methodIntegration").isBinary(false).build();

    private static final MarshallingInfo<List> AUTHORIZATIONSCOPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationScopes").isBinary(false).build();

    private static final MethodMarshaller INSTANCE = new MethodMarshaller();

    private MethodMarshaller() {
    }

    public static MethodMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Method method, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(method, "method");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(method.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(method.authorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall(method.authorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall(method.apiKeyRequired(), APIKEYREQUIRED_BINDING);
            protocolMarshaller.marshall(method.requestValidatorId(), REQUESTVALIDATORID_BINDING);
            protocolMarshaller.marshall(method.operationName(), OPERATIONNAME_BINDING);
            protocolMarshaller.marshall(method.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(method.requestModels(), REQUESTMODELS_BINDING);
            protocolMarshaller.marshall(method.methodResponses(), METHODRESPONSES_BINDING);
            protocolMarshaller.marshall(method.methodIntegration(), METHODINTEGRATION_BINDING);
            protocolMarshaller.marshall(method.authorizationScopes(), AUTHORIZATIONSCOPES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
