/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.MethodSetting;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MethodSetting} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MethodSettingMarshaller {
    private static final MarshallingInfo<Boolean> METRICSENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricsEnabled").isBinary(false).build();

    private static final MarshallingInfo<String> LOGGINGLEVEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loggingLevel").isBinary(false).build();

    private static final MarshallingInfo<Boolean> DATATRACEENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dataTraceEnabled").isBinary(false).build();

    private static final MarshallingInfo<Integer> THROTTLINGBURSTLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttlingBurstLimit").isBinary(false).build();

    private static final MarshallingInfo<Double> THROTTLINGRATELIMIT_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttlingRateLimit").isBinary(false).build();

    private static final MarshallingInfo<Boolean> CACHINGENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cachingEnabled").isBinary(false).build();

    private static final MarshallingInfo<Integer> CACHETTLINSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheTtlInSeconds").isBinary(false).build();

    private static final MarshallingInfo<Boolean> CACHEDATAENCRYPTED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheDataEncrypted").isBinary(false).build();

    private static final MarshallingInfo<Boolean> REQUIREAUTHORIZATIONFORCACHECONTROL_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("requireAuthorizationForCacheControl").isBinary(false).build();

    private static final MarshallingInfo<String> UNAUTHORIZEDCACHECONTROLHEADERSTRATEGY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("unauthorizedCacheControlHeaderStrategy").isBinary(false).build();

    private static final MethodSettingMarshaller INSTANCE = new MethodSettingMarshaller();

    private MethodSettingMarshaller() {
    }

    public static MethodSettingMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MethodSetting methodSetting, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(methodSetting, "methodSetting");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(methodSetting.metricsEnabled(), METRICSENABLED_BINDING);
            protocolMarshaller.marshall(methodSetting.loggingLevel(), LOGGINGLEVEL_BINDING);
            protocolMarshaller.marshall(methodSetting.dataTraceEnabled(), DATATRACEENABLED_BINDING);
            protocolMarshaller.marshall(methodSetting.throttlingBurstLimit(), THROTTLINGBURSTLIMIT_BINDING);
            protocolMarshaller.marshall(methodSetting.throttlingRateLimit(), THROTTLINGRATELIMIT_BINDING);
            protocolMarshaller.marshall(methodSetting.cachingEnabled(), CACHINGENABLED_BINDING);
            protocolMarshaller.marshall(methodSetting.cacheTtlInSeconds(), CACHETTLINSECONDS_BINDING);
            protocolMarshaller.marshall(methodSetting.cacheDataEncrypted(), CACHEDATAENCRYPTED_BINDING);
            protocolMarshaller.marshall(methodSetting.requireAuthorizationForCacheControl(),
                    REQUIREAUTHORIZATIONFORCACHECONTROL_BINDING);
            protocolMarshaller.marshall(methodSetting.unauthorizedCacheControlHeaderStrategyAsString(),
                    UNAUTHORIZEDCACHECONTROLHEADERSTRATEGY_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
