/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MethodSetting JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MethodSettingUnmarshaller implements Unmarshaller<MethodSetting, JsonUnmarshallerContext> {

    public MethodSetting unmarshall(JsonUnmarshallerContext context) throws Exception {
        MethodSetting.Builder methodSettingBuilder = MethodSetting.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("metricsEnabled", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.metricsEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("loggingLevel", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.loggingLevel(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("dataTraceEnabled", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.dataTraceEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("throttlingBurstLimit", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.throttlingBurstLimit(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("throttlingRateLimit", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.throttlingRateLimit(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("cachingEnabled", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.cachingEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("cacheTtlInSeconds", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.cacheTtlInSeconds(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("cacheDataEncrypted", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.cacheDataEncrypted(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("requireAuthorizationForCacheControl", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.requireAuthorizationForCacheControl(context.getUnmarshaller(Boolean.class).unmarshall(
                            context));
                }
                if (context.testExpression("unauthorizedCacheControlHeaderStrategy", targetDepth)) {
                    context.nextToken();
                    methodSettingBuilder.unauthorizedCacheControlHeaderStrategy(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return methodSettingBuilder.build();
    }

    private static final MethodSettingUnmarshaller INSTANCE = new MethodSettingUnmarshaller();

    public static MethodSettingUnmarshaller getInstance() {
        return INSTANCE;
    }
}
