/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PutGatewayResponseRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PutGatewayResponseRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PutGatewayResponseRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();

    private static final MarshallingInfo<String> RESPONSETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("response_type").isBinary(false).build();

    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusCode").isBinary(false).build();

    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> RESPONSETEMPLATES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseTemplates").isBinary(false).build();

    private static final PutGatewayResponseRequestModelMarshaller INSTANCE = new PutGatewayResponseRequestModelMarshaller();

    private PutGatewayResponseRequestModelMarshaller() {
    }

    public static PutGatewayResponseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PutGatewayResponseRequest putGatewayResponseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(putGatewayResponseRequest, "putGatewayResponseRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(putGatewayResponseRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall(putGatewayResponseRequest.responseTypeAsString(), RESPONSETYPE_BINDING);
            protocolMarshaller.marshall(putGatewayResponseRequest.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(putGatewayResponseRequest.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(putGatewayResponseRequest.responseTemplates(), RESPONSETEMPLATES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
