/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link PutMethodRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class PutMethodRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();

    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").isBinary(false).build();

    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").isBinary(false).build();

    private static final MarshallingInfo<String> OPERATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationName").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();

    private static final MarshallingInfo<Map> REQUESTMODELS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestModels").isBinary(false).build();

    private static final MarshallingInfo<String> REQUESTVALIDATORID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestValidatorId").isBinary(false).build();

    private static final MarshallingInfo<List> AUTHORIZATIONSCOPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationScopes").isBinary(false).build();

    private static final PutMethodRequestModelMarshaller INSTANCE = new PutMethodRequestModelMarshaller();

    private PutMethodRequestModelMarshaller() {
    }

    public static PutMethodRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(PutMethodRequest putMethodRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(putMethodRequest, "putMethodRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(putMethodRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall(putMethodRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall(putMethodRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(putMethodRequest.authorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall(putMethodRequest.authorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall(putMethodRequest.apiKeyRequired(), APIKEYREQUIRED_BINDING);
            protocolMarshaller.marshall(putMethodRequest.operationName(), OPERATIONNAME_BINDING);
            protocolMarshaller.marshall(putMethodRequest.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(putMethodRequest.requestModels(), REQUESTMODELS_BINDING);
            protocolMarshaller.marshall(putMethodRequest.requestValidatorId(), REQUESTVALIDATORID_BINDING);
            protocolMarshaller.marshall(putMethodRequest.authorizationScopes(), AUTHORIZATIONSCOPES_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
