/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.RequestValidator;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RequestValidator} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RequestValidatorMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<Boolean> VALIDATEREQUESTBODY_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validateRequestBody").isBinary(false).build();

    private static final MarshallingInfo<Boolean> VALIDATEREQUESTPARAMETERS_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("validateRequestParameters").isBinary(false).build();

    private static final RequestValidatorMarshaller INSTANCE = new RequestValidatorMarshaller();

    private RequestValidatorMarshaller() {
    }

    public static RequestValidatorMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RequestValidator requestValidator, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(requestValidator, "requestValidator");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(requestValidator.id(), ID_BINDING);
            protocolMarshaller.marshall(requestValidator.name(), NAME_BINDING);
            protocolMarshaller.marshall(requestValidator.validateRequestBody(), VALIDATEREQUESTBODY_BINDING);
            protocolMarshaller.marshall(requestValidator.validateRequestParameters(), VALIDATEREQUESTPARAMETERS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
