/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Resource} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();

    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentId").isBinary(false).build();

    private static final MarshallingInfo<String> PATHPART_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathPart").isBinary(false).build();

    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").isBinary(false).build();

    private static final MarshallingInfo<Map> RESOURCEMETHODS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceMethods").isBinary(false).build();

    private static final ResourceMarshaller INSTANCE = new ResourceMarshaller();

    private ResourceMarshaller() {
    }

    public static ResourceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(resource, "resource");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(resource.id(), ID_BINDING);
            protocolMarshaller.marshall(resource.parentId(), PARENTID_BINDING);
            protocolMarshaller.marshall(resource.pathPart(), PATHPART_BINDING);
            protocolMarshaller.marshall(resource.path(), PATH_BINDING);
            protocolMarshaller.marshall(resource.resourceMethods(), RESOURCEMETHODS_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
