/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.Stage;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Stage} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class StageMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").isBinary(false).build();

    private static final MarshallingInfo<String> CLIENTCERTIFICATEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientCertificateId").isBinary(false).build();

    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<Boolean> CACHECLUSTERENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterEnabled").isBinary(false).build();

    private static final MarshallingInfo<String> CACHECLUSTERSIZE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterSize").isBinary(false).build();

    private static final MarshallingInfo<String> CACHECLUSTERSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterStatus").isBinary(false).build();

    private static final MarshallingInfo<Map> METHODSETTINGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodSettings").isBinary(false).build();

    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variables").isBinary(false).build();

    private static final MarshallingInfo<String> DOCUMENTATIONVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("documentationVersion").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ACCESSLOGSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("accessLogSettings").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CANARYSETTINGS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("canarySettings").isBinary(false).build();

    private static final MarshallingInfo<Boolean> TRACINGENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tracingEnabled").isBinary(false).build();

    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTUPDATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDate").isBinary(false).build();

    private static final StageMarshaller INSTANCE = new StageMarshaller();

    private StageMarshaller() {
    }

    public static StageMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Stage stage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(stage, "stage");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(stage.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall(stage.clientCertificateId(), CLIENTCERTIFICATEID_BINDING);
            protocolMarshaller.marshall(stage.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall(stage.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(stage.cacheClusterEnabled(), CACHECLUSTERENABLED_BINDING);
            protocolMarshaller.marshall(stage.cacheClusterSize(), CACHECLUSTERSIZE_BINDING);
            protocolMarshaller.marshall(stage.cacheClusterStatusAsString(), CACHECLUSTERSTATUS_BINDING);
            protocolMarshaller.marshall(stage.methodSettings(), METHODSETTINGS_BINDING);
            protocolMarshaller.marshall(stage.variables(), VARIABLES_BINDING);
            protocolMarshaller.marshall(stage.documentationVersion(), DOCUMENTATIONVERSION_BINDING);
            protocolMarshaller.marshall(stage.accessLogSettings(), ACCESSLOGSETTINGS_BINDING);
            protocolMarshaller.marshall(stage.canarySettings(), CANARYSETTINGS_BINDING);
            protocolMarshaller.marshall(stage.tracingEnabled(), TRACINGENABLED_BINDING);
            protocolMarshaller.marshall(stage.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(stage.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall(stage.lastUpdatedDate(), LASTUPDATEDDATE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
