/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateAuthorizerResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateAuthorizerResponseUnmarshaller implements Unmarshaller<UpdateAuthorizerResponse, JsonUnmarshallerContext> {

    public UpdateAuthorizerResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateAuthorizerResponse.Builder updateAuthorizerResponseBuilder = UpdateAuthorizerResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateAuthorizerResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.type(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("providerARNs", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.providerARNs(new ListUnmarshaller<String>(context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("authType", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.authType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("authorizerUri", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.authorizerUri(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("authorizerCredentials", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.authorizerCredentials(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("identitySource", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.identitySource(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("identityValidationExpression", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.identityValidationExpression(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("authorizerResultTtlInSeconds", targetDepth)) {
                    context.nextToken();
                    updateAuthorizerResponseBuilder.authorizerResultTtlInSeconds(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateAuthorizerResponseBuilder.build();
    }

    private static final UpdateAuthorizerResponseUnmarshaller INSTANCE = new UpdateAuthorizerResponseUnmarshaller();

    public static UpdateAuthorizerResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
