/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UpdateDomainNameResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateDomainNameResponseUnmarshaller implements Unmarshaller<UpdateDomainNameResponse, JsonUnmarshallerContext> {

    public UpdateDomainNameResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateDomainNameResponse.Builder updateDomainNameResponseBuilder = UpdateDomainNameResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return updateDomainNameResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("domainName", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.domainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateName", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.certificateName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateArn", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.certificateArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("certificateUploadDate", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.certificateUploadDate(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("regionalDomainName", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.regionalDomainName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("regionalHostedZoneId", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.regionalHostedZoneId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("regionalCertificateName", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.regionalCertificateName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("regionalCertificateArn", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.regionalCertificateArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("distributionDomainName", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.distributionDomainName(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("distributionHostedZoneId", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.distributionHostedZoneId(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("endpointConfiguration", targetDepth)) {
                    context.nextToken();
                    updateDomainNameResponseBuilder.endpointConfiguration(EndpointConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return updateDomainNameResponseBuilder.build();
    }

    private static final UpdateDomainNameResponseUnmarshaller INSTANCE = new UpdateDomainNameResponseUnmarshaller();

    public static UpdateDomainNameResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
