/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.UsagePlan;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link UsagePlan} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class UsagePlanMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<List> APISTAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiStages").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> THROTTLE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("throttle").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> QUOTA_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("quota").isBinary(false).build();

    private static final MarshallingInfo<String> PRODUCTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productCode").isBinary(false).build();

    private static final UsagePlanMarshaller INSTANCE = new UsagePlanMarshaller();

    private UsagePlanMarshaller() {
    }

    public static UsagePlanMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(UsagePlan usagePlan, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(usagePlan, "usagePlan");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(usagePlan.id(), ID_BINDING);
            protocolMarshaller.marshall(usagePlan.name(), NAME_BINDING);
            protocolMarshaller.marshall(usagePlan.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(usagePlan.apiStages(), APISTAGES_BINDING);
            protocolMarshaller.marshall(usagePlan.throttle(), THROTTLE_BINDING);
            protocolMarshaller.marshall(usagePlan.quota(), QUOTA_BINDING);
            protocolMarshaller.marshall(usagePlan.productCode(), PRODUCTCODE_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
