/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.apigateway.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * UsagePlan JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UsagePlanUnmarshaller implements Unmarshaller<UsagePlan, JsonUnmarshallerContext> {

    public UsagePlan unmarshall(JsonUnmarshallerContext context) throws Exception {
        UsagePlan.Builder usagePlanBuilder = UsagePlan.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.id(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("apiStages", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.apiStages(new ListUnmarshaller<ApiStage>(ApiStageUnmarshaller.getInstance())
                            .unmarshall(context));
                }
                if (context.testExpression("throttle", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.throttle(ThrottleSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("quota", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.quota(QuotaSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("productCode", targetDepth)) {
                    context.nextToken();
                    usagePlanBuilder.productCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return usagePlanBuilder.build();
    }

    private static final UsagePlanUnmarshaller INSTANCE = new UsagePlanUnmarshaller();

    public static UsagePlanUnmarshaller getInstance() {
        return INSTANCE;
    }
}
