/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.transform.CanarySettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanarySettings
implements StructuredPojo,
ToCopyableBuilder<Builder, CanarySettings> {
    private final Double percentTraffic;
    private final String deploymentId;
    private final Map<String, String> stageVariableOverrides;
    private final Boolean useStageCache;

    private CanarySettings(BuilderImpl builder) {
        this.percentTraffic = builder.percentTraffic;
        this.deploymentId = builder.deploymentId;
        this.stageVariableOverrides = builder.stageVariableOverrides;
        this.useStageCache = builder.useStageCache;
    }

    public Double percentTraffic() {
        return this.percentTraffic;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public Map<String, String> stageVariableOverrides() {
        return this.stageVariableOverrides;
    }

    public Boolean useStageCache() {
        return this.useStageCache;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentTraffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageVariableOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.useStageCache());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanarySettings)) {
            return false;
        }
        CanarySettings other = (CanarySettings)obj;
        return Objects.equals(this.percentTraffic(), other.percentTraffic()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.stageVariableOverrides(), other.stageVariableOverrides()) && Objects.equals(this.useStageCache(), other.useStageCache());
    }

    public String toString() {
        return ToString.builder((String)"CanarySettings").add("PercentTraffic", (Object)this.percentTraffic()).add("DeploymentId", (Object)this.deploymentId()).add("StageVariableOverrides", this.stageVariableOverrides()).add("UseStageCache", (Object)this.useStageCache()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "percentTraffic": {
                return Optional.ofNullable(clazz.cast(this.percentTraffic()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "stageVariableOverrides": {
                return Optional.ofNullable(clazz.cast(this.stageVariableOverrides()));
            }
            case "useStageCache": {
                return Optional.ofNullable(clazz.cast(this.useStageCache()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CanarySettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Double percentTraffic;
        private String deploymentId;
        private Map<String, String> stageVariableOverrides = DefaultSdkAutoConstructMap.getInstance();
        private Boolean useStageCache;

        private BuilderImpl() {
        }

        private BuilderImpl(CanarySettings model) {
            this.percentTraffic(model.percentTraffic);
            this.deploymentId(model.deploymentId);
            this.stageVariableOverrides(model.stageVariableOverrides);
            this.useStageCache(model.useStageCache);
        }

        public final Double getPercentTraffic() {
            return this.percentTraffic;
        }

        @Override
        public final Builder percentTraffic(Double percentTraffic) {
            this.percentTraffic = percentTraffic;
            return this;
        }

        public final void setPercentTraffic(Double percentTraffic) {
            this.percentTraffic = percentTraffic;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Map<String, String> getStageVariableOverrides() {
            return this.stageVariableOverrides;
        }

        @Override
        public final Builder stageVariableOverrides(Map<String, String> stageVariableOverrides) {
            this.stageVariableOverrides = MapOfStringToStringCopier.copy(stageVariableOverrides);
            return this;
        }

        public final void setStageVariableOverrides(Map<String, String> stageVariableOverrides) {
            this.stageVariableOverrides = MapOfStringToStringCopier.copy(stageVariableOverrides);
        }

        public final Boolean getUseStageCache() {
            return this.useStageCache;
        }

        @Override
        public final Builder useStageCache(Boolean useStageCache) {
            this.useStageCache = useStageCache;
            return this;
        }

        public final void setUseStageCache(Boolean useStageCache) {
            this.useStageCache = useStageCache;
        }

        public CanarySettings build() {
            return new CanarySettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CanarySettings> {
        public Builder percentTraffic(Double var1);

        public Builder deploymentId(String var1);

        public Builder stageVariableOverrides(Map<String, String> var1);

        public Builder useStageCache(Boolean var1);
    }
}

