/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.EndpointType;
import software.amazon.awssdk.services.apigateway.model.ListOfEndpointTypeCopier;
import software.amazon.awssdk.services.apigateway.transform.EndpointConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointConfiguration> {
    private final List<String> types;

    private EndpointConfiguration(BuilderImpl builder) {
        this.types = builder.types;
    }

    public List<EndpointType> types() {
        return TypeConverter.convert(this.types, EndpointType::fromValue);
    }

    public List<String> typesAsStrings() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)obj;
        return Objects.equals(this.typesAsStrings(), other.typesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"EndpointConfiguration").add("Types", this.typesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointConfiguration model) {
            this.typesWithStrings(model.types);
        }

        public final Collection<String> getTypes() {
            return this.types;
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<EndpointType> types) {
            this.types = ListOfEndpointTypeCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(EndpointType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ListOfEndpointTypeCopier.copy(types);
        }

        public EndpointConfiguration build() {
            return new EndpointConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointConfiguration> {
        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<EndpointType> var1);

        public Builder types(EndpointType ... var1);
    }
}

