/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSdkResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetSdkResponse> {
    private final String contentType;
    private final String contentDisposition;
    private final SdkBytes body;

    private GetSdkResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.body = builder.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public SdkBytes body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSdkResponse)) {
            return false;
        }
        GetSdkResponse other = (GetSdkResponse)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.contentDisposition(), other.contentDisposition()) && Objects.equals(this.body(), other.body());
    }

    public String toString() {
        return ToString.builder((String)"GetSdkResponse").add("ContentType", (Object)this.contentType()).add("ContentDisposition", (Object)this.contentDisposition()).add("Body", (Object)this.body()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "contentDisposition": {
                return Optional.ofNullable(clazz.cast(this.contentDisposition()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private String contentDisposition;
        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSdkResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.contentDisposition(model.contentDisposition);
            this.body(model.body);
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = StandardMemberCopier.copy((SdkBytes)body);
            return this;
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public GetSdkResponse build() {
            return new GetSdkResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetSdkResponse> {
        public Builder contentType(String var1);

        public Builder contentDisposition(String var1);

        public Builder body(SdkBytes var1);
    }
}

