/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfPatchOperationCopier;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMethodRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, UpdateMethodRequest> {
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final List<PatchOperation> patchOperations;

    private UpdateMethodRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.patchOperations = builder.patchOperations;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public List<PatchOperation> patchOperations() {
        return this.patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchOperations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodRequest)) {
            return false;
        }
        UpdateMethodRequest other = (UpdateMethodRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.patchOperations(), other.patchOperations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMethodRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("PatchOperations", this.patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "patchOperations": {
                return Optional.ofNullable(clazz.cast(this.patchOperations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return this.patchOperations != null ? (Collection)this.patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation ... patchOperations) {
            this.patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder> ... patchOperations) {
            this.patchOperations(Stream.of(patchOperations).map(c -> (PatchOperation)((PatchOperation.Builder)PatchOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMethodRequest build() {
            return new UpdateMethodRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, UpdateMethodRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder patchOperations(Collection<PatchOperation> var1);

        public Builder patchOperations(PatchOperation ... var1);

        public Builder patchOperations(Consumer<PatchOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

