/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodCopier;
import software.amazon.awssdk.services.apigateway.model.Method;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateResourceResponse> {
    private final String id;
    private final String parentId;
    private final String pathPart;
    private final String path;
    private final Map<String, Method> resourceMethods;

    private UpdateResourceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.pathPart = builder.pathPart;
        this.path = builder.path;
        this.resourceMethods = builder.resourceMethods;
    }

    public String id() {
        return this.id;
    }

    public String parentId() {
        return this.parentId;
    }

    public String pathPart() {
        return this.pathPart;
    }

    public String path() {
        return this.path;
    }

    public Map<String, Method> resourceMethods() {
        return this.resourceMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPart());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceMethods());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceResponse)) {
            return false;
        }
        UpdateResourceResponse other = (UpdateResourceResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.pathPart(), other.pathPart()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.resourceMethods(), other.resourceMethods());
    }

    public String toString() {
        return ToString.builder((String)"UpdateResourceResponse").add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("PathPart", (Object)this.pathPart()).add("Path", (Object)this.path()).add("ResourceMethods", this.resourceMethods()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "parentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "pathPart": {
                return Optional.ofNullable(clazz.cast(this.pathPart()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "resourceMethods": {
                return Optional.ofNullable(clazz.cast(this.resourceMethods()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String parentId;
        private String pathPart;
        private String path;
        private Map<String, Method> resourceMethods = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceResponse model) {
            super(model);
            this.id(model.id);
            this.parentId(model.parentId);
            this.pathPart(model.pathPart);
            this.path(model.path);
            this.resourceMethods(model.resourceMethods);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getParentId() {
            return this.parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public final String getPathPart() {
            return this.pathPart;
        }

        @Override
        public final Builder pathPart(String pathPart) {
            this.pathPart = pathPart;
            return this;
        }

        public final void setPathPart(String pathPart) {
            this.pathPart = pathPart;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Map<String, Method.Builder> getResourceMethods() {
            return this.resourceMethods != null ? CollectionUtils.mapValues(this.resourceMethods, Method::toBuilder) : null;
        }

        @Override
        public final Builder resourceMethods(Map<String, Method> resourceMethods) {
            this.resourceMethods = MapOfMethodCopier.copy(resourceMethods);
            return this;
        }

        public final void setResourceMethods(Map<String, Method.BuilderImpl> resourceMethods) {
            this.resourceMethods = MapOfMethodCopier.copyFromBuilder(resourceMethods);
        }

        @Override
        public UpdateResourceResponse build() {
            return new UpdateResourceResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, UpdateResourceResponse> {
        public Builder id(String var1);

        public Builder parentId(String var1);

        public Builder pathPart(String var1);

        public Builder path(String var1);

        public Builder resourceMethods(Map<String, Method> var1);
    }
}

