/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfKeyUsagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUsageResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateUsageResponse> {
    private final String usagePlanId;
    private final String startDate;
    private final String endDate;
    private final String position;
    private final Map<String, List<List<Long>>> items;

    private UpdateUsageResponse(BuilderImpl builder) {
        super(builder);
        this.usagePlanId = builder.usagePlanId;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.position = builder.position;
        this.items = builder.items;
    }

    public String usagePlanId() {
        return this.usagePlanId;
    }

    public String startDate() {
        return this.startDate;
    }

    public String endDate() {
        return this.endDate;
    }

    public String position() {
        return this.position;
    }

    public Map<String, List<List<Long>>> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsageResponse)) {
            return false;
        }
        UpdateUsageResponse other = (UpdateUsageResponse)((Object)obj);
        return Objects.equals(this.usagePlanId(), other.usagePlanId()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"UpdateUsageResponse").add("UsagePlanId", (Object)this.usagePlanId()).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("Position", (Object)this.position()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "usagePlanId": {
                return Optional.ofNullable(clazz.cast(this.usagePlanId()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String usagePlanId;
        private String startDate;
        private String endDate;
        private String position;
        private Map<String, List<List<Long>>> items = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsageResponse model) {
            super(model);
            this.usagePlanId(model.usagePlanId);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.position(model.position);
            this.items(model.items);
        }

        public final String getUsagePlanId() {
            return this.usagePlanId;
        }

        @Override
        public final Builder usagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
            return this;
        }

        public final void setUsagePlanId(String usagePlanId) {
            this.usagePlanId = usagePlanId;
        }

        public final String getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Map<String, ? extends Collection<? extends Collection<Long>>> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
            return this;
        }

        public final void setItems(Map<String, ? extends Collection<? extends Collection<Long>>> items) {
            this.items = MapOfKeyUsagesCopier.copy(items);
        }

        @Override
        public UpdateUsageResponse build() {
            return new UpdateUsageResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, UpdateUsageResponse> {
        public Builder usagePlanId(String var1);

        public Builder startDate(String var1);

        public Builder endDate(String var1);

        public Builder position(String var1);

        public Builder items(Map<String, ? extends Collection<? extends Collection<Long>>> var1);
    }
}

