/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.AccessLogSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AccessLogSettingsMarshaller {
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("format").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationArn").isBinary(false).build();
    private static final AccessLogSettingsMarshaller INSTANCE = new AccessLogSettingsMarshaller();

    private AccessLogSettingsMarshaller() {
    }

    public static AccessLogSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AccessLogSettings accessLogSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)accessLogSettings, (String)"accessLogSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)accessLogSettings.format(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)accessLogSettings.destinationArn(), DESTINATIONARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

