/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.DeploymentCanarySettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentCanarySettingsMarshaller {
    private static final MarshallingInfo<Double> PERCENTTRAFFIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("percentTraffic").isBinary(false).build();
    private static final MarshallingInfo<Map> STAGEVARIABLEOVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageVariableOverrides").isBinary(false).build();
    private static final MarshallingInfo<Boolean> USESTAGECACHE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useStageCache").isBinary(false).build();
    private static final DeploymentCanarySettingsMarshaller INSTANCE = new DeploymentCanarySettingsMarshaller();

    private DeploymentCanarySettingsMarshaller() {
    }

    public static DeploymentCanarySettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentCanarySettings deploymentCanarySettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deploymentCanarySettings, (String)"deploymentCanarySettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deploymentCanarySettings.percentTraffic(), PERCENTTRAFFIC_BINDING);
            protocolMarshaller.marshall(deploymentCanarySettings.stageVariableOverrides(), STAGEVARIABLEOVERRIDES_BINDING);
            protocolMarshaller.marshall((Object)deploymentCanarySettings.useStageCache(), USESTAGECACHE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

