/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GetApiKeyRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetApiKeyRequestModelMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("api_Key").isBinary(false).build();
    private static final MarshallingInfo<Boolean> INCLUDEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("includeValue").isBinary(false).build();
    private static final GetApiKeyRequestModelMarshaller INSTANCE = new GetApiKeyRequestModelMarshaller();

    private GetApiKeyRequestModelMarshaller() {
    }

    public static GetApiKeyRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetApiKeyRequest getApiKeyRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getApiKeyRequest), (String)"getApiKeyRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getApiKeyRequest.apiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall((Object)getApiKeyRequest.includeValue(), INCLUDEVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

