/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.io.InputStream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.apigateway.model.GetExportResponse;
import software.amazon.awssdk.utils.IoUtils;

public class GetExportResponseUnmarshaller
implements Unmarshaller<GetExportResponse, JsonUnmarshallerContext> {
    private static final GetExportResponseUnmarshaller INSTANCE = new GetExportResponseUnmarshaller();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetExportResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputStream is;
        GetExportResponse.Builder getExportResponseBuilder = GetExportResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getExportResponseBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Disposition") != null) {
                context.setCurrentHeader("Content-Disposition");
                getExportResponseBuilder.contentDisposition((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
        }
        if ((is = (InputStream)context.getHttpResponse().content().orElse(null)) != null) {
            try {
                getExportResponseBuilder.body(SdkBytes.fromInputStream((InputStream)is));
            }
            finally {
                IoUtils.closeQuietly((AutoCloseable)is, null);
            }
        }
        return (GetExportResponse)((Object)getExportResponseBuilder.build());
    }

    public static GetExportResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

