/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutMethodResponseRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("status_code").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> RESPONSEMODELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("responseModels").isBinary(false).build();
    private static final PutMethodResponseRequestModelMarshaller INSTANCE = new PutMethodResponseRequestModelMarshaller();

    private PutMethodResponseRequestModelMarshaller() {
    }

    public static PutMethodResponseRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutMethodResponseRequest putMethodResponseRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putMethodResponseRequest), (String)"putMethodResponseRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putMethodResponseRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)putMethodResponseRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)putMethodResponseRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)putMethodResponseRequest.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall(putMethodResponseRequest.responseParameters(), RESPONSEPARAMETERS_BINDING);
            protocolMarshaller.marshall(putMethodResponseRequest.responseModels(), RESPONSEMODELS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

