/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.RequestValidator;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RequestValidatorMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VALIDATEREQUESTBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validateRequestBody").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VALIDATEREQUESTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validateRequestParameters").isBinary(false).build();
    private static final RequestValidatorMarshaller INSTANCE = new RequestValidatorMarshaller();

    private RequestValidatorMarshaller() {
    }

    public static RequestValidatorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RequestValidator requestValidator, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)requestValidator, (String)"requestValidator");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)requestValidator.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)requestValidator.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)requestValidator.validateRequestBody(), VALIDATEREQUESTBODY_BINDING);
            protocolMarshaller.marshall((Object)requestValidator.validateRequestParameters(), VALIDATEREQUESTPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

