/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentId").isBinary(false).build();
    private static final MarshallingInfo<String> PATHPART_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pathPart").isBinary(false).build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").isBinary(false).build();
    private static final MarshallingInfo<Map> RESOURCEMETHODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceMethods").isBinary(false).build();
    private static final ResourceMarshaller INSTANCE = new ResourceMarshaller();

    private ResourceMarshaller() {
    }

    public static ResourceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Resource resource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resource, (String)"resource");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resource.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)resource.parentId(), PARENTID_BINDING);
            protocolMarshaller.marshall((Object)resource.pathPart(), PATHPART_BINDING);
            protocolMarshaller.marshall((Object)resource.path(), PATH_BINDING);
            protocolMarshaller.marshall(resource.resourceMethods(), RESOURCEMETHODS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

