/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.StageKey;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StageKeyMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("restApiId").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();
    private static final StageKeyMarshaller INSTANCE = new StageKeyMarshaller();

    private StageKeyMarshaller() {
    }

    public static StageKeyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StageKey stageKey, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stageKey, (String)"stageKey");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stageKey.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)stageKey.stageName(), STAGENAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

